*#---------------------------------------------------------
*#
*#       GENERAL INFORMATION FILE ('ROOT_GEN.DAT')
*#
*#
*#
*#  Card.1_HEAD
*#  Card.2_NUMNP,NUMEL,NDIM,IAXISYM,NUMMAT,NHV
*#  Card.3_MXDIFN,MBANDT,MFRONTH,NDF,MNVAL,ISOLVE
*#  Card.4_NDFTYPE,NFLUXTYPE
*#  Card.5_IOPTDISPL,IOPTPL,IOPTPG,IOPTTEMP,IOPTXWS
*#  Card.6_IOPTXHL,IUPDPOR,IOPTXWG,IOPTXAL,IOPTPC,IOPTHYS,IUPDC
*#  Card.7_FLAG1,FLAG2,FLAG3,FLAG4
*#  Card.8_EPSILON,THETA,PGCONS,TCONS,PLCONS
*#  Card.9_TIME,DTIME,TIME1,DTIMEC,TIMEMAX,FACTTIME,EPSILONI,ITIMEI,WRITEFREQ
*#  Card.10_IOWIT,INTER,ITERMAX,IOWDRAC,ITERMAXS,ITIME
*#  Card.11_DELMXU,FACU,DELFMX,DUMX(Omit if IOPTDISPL=0)
*#          DELMXPL,FACPL,DELQWMX,DPLMX(Omit if IOPTPL=0)
*#          DELMXPG,FACPG,DELQAMX,DPGMX(Omit if IOPTPG=0)
*#          DELMXT,FACT,DELQMX,DTMX(Omit if IOPTTEMP=0)
*#          DELMXI,FACI,DELIMX,DIMX(Omit if IOPTXWS=0)
*#  Card.11bis_DXS,DRS,DRSREL (Only if ISOLVE=5)
*#  -1
*#  Card.12_GRAVITY(1),...,GRAVITY(ndim)
*#  More cards
*#
*#
*#---------------------------------------------------------
*#
*#
*#
*realformat " % f "
*intformat " % i "
*set var iunknown=0
*set var runknown=0.0
*#---------------------------------------------------------
*# Card.1_HEAD
*#---------------------------------------------------------
*GenData(_Title_of_the_problem:)                                                  
*\
*#---------------------------------------------------------
*# Card.2_NUMNP,NUMEL,NDIM,IAXISYM,NUMMAT,NHV
*#---------------------------------------------------------
*set var iaxisym=0
*if(strcmp(GenData(_Axisymmetry),"_Around_y-axis")==0)
*set var iaxisym=1
*endif
*format " % i % i % i % i % i % i"
*npoin*nelem*ndime*iaxisym*nmats*iunknown
*\
*#---------------------------------------------------------
*# Card.3_MXDIFN,MBANDT,MFRONTH,NDF,MNVAL,ISOLVE
*#---------------------------------------------------------
*set var ndf=operation(GenData(_Stress_equilibrium_(unknow_displacement_u),INT)*ndime+GenData(_Mass_balance_of_water_(unknow_liquid_pressure_Pl),INT)+GenData(_Mass_balance_of_air_(unknown__gas_pressure_Pg),INT)+GenData(_Energy_balance_(unknown_temperature),INT)+GenData(_Solute_transport,INT))
*set var isolve=5
*if(strcmp(GenData(_Solver_type),"direct_LU+Back3")==0)
*set var isolve=3
*endif
*format " % i % i % i % i % i % i"
*iunknown*iunknown*iunknown*ndf*iunknown*isolve
*\
*#---------------------------------------------------------
*# Card.4_NDFTYPE,NFLUXTYPE_(Calculated by transb)
*#---------------------------------------------------------
*format " % i % i"
*iunknown*iunknown
*\
*#---------------------------------------------------------
*# Card.5_IOPTDISPL,IOPTPL,IOPTPG,IOPTTEMP,IOPTXWS
*#---------------------------------------------------------
*format " % i % i % i % i % i"
*set var ioptxws=2
*if(strcmp(GenData(_Module),"_Reactive_transport_CheMec")==0)
*set var ioptxws=3
*endif
*if(strcmp(GenData(_Module),"_Reactive_transport_CheProf")==0)
*set var ioptxws=4
*endif
*if(GenData(_Solute_transport,INT)==0)
*set var ioptxws=0
*endif
*GenData(_Stress_equilibrium_(unknow_displacement_u),INT)*GenData(_Mass_balance_of_water_,INT)*GenData(_Mass_balance_of_air_,INT)*GenData(_Energy_balance_,INT)*ioptxws
*\
*#---------------------------------------------------------
*# Card.6_IOPTXHL,IUPDPOR,IOPTXWG,IOPTXAL,IOPTPC,IOPTHYS,IUPDC
*#---------------------------------------------------------
*format " % i % i % i % i % i % i % i"
*set var iupdpor=0
*if(strcmp(GenData(_Porosity_updated_with_solid_dissolution/precipitation),"_Yes")==0)
*set var iopdpor=1
*endif
*set var ioptxwg=0
*if(strcmp(GenData(_Vapour_into_gas_phase),"_Not_allowed")==0)
*set var ioptxwg=1
*endif
*set var ioptxal=0
*if(strcmp(GenData(_Dissolved_air_into_liquid_phase),"_Not_allowed")==0)
*set var ioptxal=1
*endif
*set var ioptpc=-1
*if(strcmp(GenData(_Elemental_relative_permeability_computed_from),"Elemental_suction_-consistent_approach-")==0)
*set var ioptpc=0
*endif
*if(strcmp(GenData(_Elemental_relative_permeability_computed_from),"Average_nodal_relative_permeabilities")==0)
*set var ioptpc=-2
*endif
*if(strcmp(GenData(_Elemental_relative_permeability_computed_from),"Average_nodal_relative_permeabilities_-applies_also_for_derivatives-")==0)
*set var ioptpc=-3
*endif
*if(strcmp(GenData(_Elemental_relative_permeability_computed_from),"Maximal_nodal_relative_permeability")==0)
*set var ioptpc=-4
*endif
*set var iupdc=0
*if(strcmp(GenData(_Updated_lagrangian_method),"_Yes")==0)
*set var iupdc=1
*endif
*GenData(_Solid_soluble_halite_type)*iupdpor*ioptxwg*ioptxal*ioptpc*iunknown*iupdc
*\
*#---------------------------------------------------------
*# Card.7_FLAG1,FLAG2,FLAG3,FLAG4,FLAG5
*#---------------------------------------------------------
*format " % i % i % i % i % i"
*set var iflag1=0
*if(strcmp(GenData(_Convergence_criterion),"On_nodal_correction_and_residual_(only_for_very_special_case-_see_manual)")==0)
*set var iflag1=1
*endif
*if(strcmp(GenData(_Convergence_criterion),"On_nodal_correction_or_residual_and_on_both_for_contours")==0)
*set var iflag1=2
*endif
*iflag1*iunknown*iunknown*iunknown*iunknown
*\                                                         
*#---------------------------------------------------------
*# Card.8_EPSILON,THETA,PGCONS,TCONS,PLCONS
*#---------------------------------------------------------
*format " % e % e % e % e % e"
*GenData(_Epsilon_(intermediate_time_for_nonlinear_functions),REAL)*GenData(_Theta_(intermediate_time_for_implicit_solution),REAL)*GenData(_Constant_Pg_[MPa],REAL)*GenData(_Constant_Temp_[C],REAL)*GenData(_Constant_Pl_[MPa],REAL)
*\
*#---------------------------------------------------------
*# Card.9_TIME,DTIME,TIME1,DTIMEC,TIMEMAX,FACTTIME,EPSILONI,ITIMEI,WRITEFREQ
*#---------------------------------------------------------
*#format " % e % e % e % e % e % e % e % e % e"
*#runknown*runknown*runknown*runknown*runknown*runknown*runknown*runknown*runknown
*\
*#---------------------------------------------------------
*# Card.10_IOWIT,INTER,ITERMAX,IOWDRAC,ITERMAXS,ITIME
*#---------------------------------------------------------
*format " % i % i % i % i % i % i % i % i % i"
*set var iowit=2
*if(strcmp(GenData(_Write_numerical_process_information),"None")==0)
*set var iowit=0
*endif
*if(strcmp(GenData(_Write_numerical_process_information),"Partial")==0)
*set var iowit=1
*endif
*set var iowdrac=2
*if(strcmp(GenData(_Output_points_),"One_gauss_point")==0)
*set var iowdrac=5
*endif
*if(strcmp(GenData(_Output_points_),"All_gauss_points")==0)
*set var iowdrac=6
*endif
*set var imkbackup=0
*if(strcmp(GenData(_Backup),"_Save_Last")==0)
*set var imkbackup=1
*endif
*if(strcmp(GenData(_Backup),"_Save_All")==0)
*set var imkbackup=2
*endif
*iowit*GenData(_Writing_frequency_,INT)*GenData(_Max_number_of_iterations_per_time_step,INT)*iowdrac*GenData(_Max_number_of_solver_iterations_CGS,INT)*GenData(_Time_step_control_(see_manual),INT)*imkbackup*GenData(_Write_all_information)*GenData(_Separated_output_files_)
*if(iowdrac==2)
*if(IMKBACKUP>0)
*MessageBox ERROR: BACKUP IS NOT COMPATIBLE WITH NODAL OUTPUT. USE GAUSS POINTS OUTPUT.
*endif
*if(strcmp(GenData(_Write_all_information),"0")==0)
*MessageBox ERROR: PARTIAL OUTPUT INFORMATION IS NOT COMPATIBLE WITH NODAL OUTPUT. USE GAUSS POINTS OUTPUT.
*endif
*endif
*\
*#---------------------------------------------------------
*# Card.11_DELMXU,FACU,DELFMX,DUMX(Omit if IOPTDISPL=0)
*#         DELMXPL,FACPL,DELQWMX,DPLMX(Omit if IOPTPL=0)
*#         DELMXPG,FACPG,DELQAMX,DPGMX(Omit if IOPTPG=0)
*#         DELMXT,FACT,DELQMX,DTMX(Omit if IOPTTEMP=0)
*#         DELMXI,FACI,DELIMX,DIMX(Omit if IOPTXWS=0)
*#---------------------------------------------------------
*format " % e % e % e"
*set var fac=0.
*if(GenData(_Stress_equilibrium_(unknow_displacement_u),INT)==1)
*GenData(_Max_Abs_Displacement_[m],REAL)*GenData(_Max_Nod_Bal_Forces_[MN],REAL)*GenData(_Displacement_Iter_Corr_[m],REAL)
*endif
*format " % e % e % e"
*if(GenData(_Mass_balance_of_water_(unknow_liquid_pressure_Pl),INT)==1)
*GenData(_Max_Abs_Pl_[MPa],REAL)*GenData(_Max_Nod_Water_Mass_Bal_[kg/s],REAL)*GenData(_Pl_Iter_Corr_[MPa],REAL)
*endif
*format " % e % e % e"
*if(GenData(_Mass_balance_of_air_(unknown__gas_pressure_Pg),INT)==1)
*GenData(_Max_Abs_Pg_[MPa],REAL)*GenData(_Max_Nod_Air_Mass_Bal_[kg/s],REAL)*GenData(_Pg_Iter_Corr_[MPa],REAL)
*endif
*format " % e % e % e"
*if(GenData(_Energy_balance_(unknown_temperature),INT)==1)
*GenData(_Max_Abs_Temp_[C],REAL)*GenData(_Max_Nod_Energy_Mass_Bal_[J/s],REAL)*GenData(_Temp_Iter_Corr_[C],REAL)
*endif
*format " % e % e % e"
*if(GenData(_Solute_transport,INT)==1)
*GenData(_Max_Abs_Solute,REAL)*GenData(_Max_Nod_Solute_Mass_Bal_[kg/s],REAL)*GenData(_Solute_Iter_Corr,REAL)
*endif
*\
*#---------------------------------------------------------
*# Card.11bis_DXS,DRS,DRSREL (Only if ISOLVE=5)
*#---------------------------------------------------------
*format " % e % e % e % i"
*if(strcmp(GenData(_Solver_type),"iterative_Sparse+CGS")==0)
*GenData(_Max_abs_solver_error_variable_CGS,REAL)*GenData(_Max_abs_solver_error_residual_CGS,REAL)*GenData(_Max_rel_solver_error_residual_CGS,REAL)*GenData(_Num_threads_parallel,INT)                                              
*endif
*\
*#---------------------------------------------------------
*# Card.12_GRAVITY(1),...,GRAVITY(ndim)
*#---------------------------------------------------------
*if(ndime==1)
*format " % e"
*GenData(_Gravity_Z_(Y_for_2-D),REAL)
*endif
*if(ndime==2)
*format " % e % e"
*GenData(_Gravity_Y_component,REAL)*GenData(_Gravity_Z_(Y_for_2-D),REAL)
*endif
*if(ndime==3)
*format " % e % e % e"
*GenData(_Gravity_X_component,REAL)*GenData(_Gravity_Y_component,REAL)*GenData(_Gravity_Z_(Y_for_2-D),REAL)
*endif
*#---------------------------------------------------------
*# Card.13_Writing_options
*#---------------------------------------------------------
*format " % i % i % i % i % i % i "
*GenData(_Write_Displacements)*GenData(_Write_Liquid_Pressure)*GenData(_Write_Gas_Pressure)*GenData(_Write_Temperature)*GenData(_Write_xws)*GenData(_Write_Concentration)
*format " % i % i % i % i % i "
*GenData(_Write_Halite_Concent)*GenData(_Write_Vapour_Concent)*GenData(_Write_Gas_Density)*GenData(_Write_Diss_air_conc)*GenData(_Write_Liq_Dens)
*format " % i % i % i % i % i "
*GenData(_Write_porosity)*GenData(_Write_Liq_Sat_Deg)*GenData(_Write_i_heat_conductive)*GenData(_Write_q_liquid_advective)*GenData(_Write_q_gas_advective)
*format " % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i % i% i % i % i % i"
*GenData(_Write_Stresses)*GenData(_Write_P0s_TEP_model)*GenData(_Write_EVP_viscopl_model)*GenData(_Write_EDP_viscopl_model)*GenData(_Write_P0_viscopl_model)*GenData(_Write_J0F_viscopl_model)*GenData(_Write_M_viscopl_model)*GenData(_Write_J0G_viscopl_model)*GenData(_Write_Tensile_res_argillite)*GenData(_Write_ED_locus_argillite)*GenData(_Write_EP_multiplier_argillite)*GenData(_Write_ED_multiplier_argillite)*GenData(_Write_Bond_stresses_argillite)*GenData(_Write_Strains_argillite)*GenData(_Write_EP_Strains_argillite)*GenData(_Write_ED_Strains_argillite)*GenData(_Write_bond_CASM)*GenData(_Write_Stresses_Eff)*GenData(_Write_Invariant_p)*GenData(_Write_Invariant_p_Eff)*GenData(_Write_Invariant_J)*GenData(_Write_Invariant_Theta)*GenData(_Write_Strains)*GenData(_Write_Invariant_E_vol)*GenData(_Write_Invariant_E_dev)*GenData(_Write_Joint_Aperture)*GenData(_Write_Joint_Slide)*GenData(_Write_Joint_Stress_N)*GenData(_Write_Joint_Tau)*GenData(_Write_P0_BExMo)*GenData(_Write_GD_BExMo)*GenData(_Write_GI_BExMo)*GenData(_Write_e_mic_BExMo)*GenData(_Write_EP_LC_BExMo)*GenData(_Write_EP_SD_BExMo)*GenData(_Write_EP_SI_BExMo)
*format " % i % i % i % i % i % i % i % i % i % i % i"
*GenData(_Write_i_liquid_diff_disp)*GenData(_Write_i_gas_diff_disp)*GenData(_Write_i_heat_disp)*GenData(_Write_isolute)*GenData(_Write_head)*GenData(_Write_Water_uptake)*GenData(_Write_Ice_Pressure)*GenData(_Write_Permeability)*GenData(_Write_Relative_Humidity)*GenData(_Write_Plastic_work)*GenData(_Write_Dry_density)
More cards
