*#------------------------------------------------------------
*#
*#      AUXILIAR CONFIGURATION FILE: CODE_BRIGHT4.BAS
*#
*#
*#
*#1      Number of materials             (NUMMAT Card.2 ROOT_GEN.DAT)
*#2      Number of constitutive laws
*#3      Constitutive law number         (for all laws)
*#4  Material number i       (for all materials)
*#5  intervals for law j     .  (for all laws)
*#6  ITYCL               .   (loop for intervals for law j)
*#  P1              .   ...
*#  P2              .   ...
*#  P3              .   ...
*#  P4              .   ...
*#  P5              .   ...
*#  P6              .   ...
*#  P7              .   ...
*#  P8              .   ...
*#  P9              .   ...
*#  P10             .   ...
*#  [blank line]            .   ...
*#  -1      End material: i
*#  Endmat
*#
*#
*#.................................................................
*#
*#
*#      HOW TO USE NEW CONSTITUTIVE LAWS?
*#
*#      1.-     Increment 'NUMBER OF CONSTITUTIVE LAWS' (right now 53)
*#      2.-     Add 'Law number' after the last one
*#      3.-     Modify law name (**************) in the sentences:
*#
*#            *#
*#            *#      LAW '************** descriptor'
*#            *#
*#            *#
*#            *set var totalprop=0
*#            *for(i=1;i<(MatProp(**************,INT)+1);i=i+1)
*#            *set var totalprop=totalprop+1
*#            *endfor
*#            *set var matpropintvl=operation(totalprop(INT)/11)
*#            *matpropintvl(INT)
*#            *for(i=1;i<(MatProp(**************,INT)+1);i=i+1)
*#            *MatProp(**************,*i,REAL) 
*#            *endfor
*#
*#
*#      4.-     Modify archive 'CODE_BRIGHT.MAT' including this law
*#
*#
*#            QUESTION: **************:(ITYCL,P1,P2,P3,P4,P5,P6,P7,P8,P9,P10)
*#            VALUE: #N# 11 0 0 0 0 0 0 0 0 0 0 0
*#      
*#      
*#      
*#   WARNNING: Be carefull with order in CODE_BRIGHT.MAT File !!
*#
*#.................................................................
*realformat "%  e"
*intformat "%  i"
*#
*#  Number of materials
*#
*nmats(INT)
*#
*#  Number of constitutive laws
*#
   53
*#
*#      Constitutive laws number (same order that CODE_BRIGHT.MAT)
*#
    1
    5
    4
    2
    3
   33
   34
   35
   36
   21
   22
   23
   24
   25
   26
   27
   70
   71
   72
   73
   74
   75
   76
   77
   78
   79
    6
   66 
    7
   14
   19
   11
   12
    8
    9
   20
   10
   15
   16
   17
   18
   50
   90
   91
   80
   81
   82
   83
   84
   85
   86
   87 
   88
*#
*#      End of constitutive law numbers
*#
*#.................................................................
*#
*#
*loop materials
*#
*#  Material number
*#
*MatNum(INT)
*#
*#      LAW 1
*#
*#
*set var ilaws=1
*set var totalprop=0
*for(i=1;i<(MatProp(_Linear_Elasticity_1,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Linear_Elasticity_1,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 5
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Linear_Elasticity_2,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Linear_Elasticity_2,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 4
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Nonlinear_Elasticity,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Nonlinear_Elasticity,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 2
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Viscoelasticity_-_creep,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Viscoelasticity_-_creep,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 3
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Viscoplasticity_-_creep,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Viscoplasticity_-_creep,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 33
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_VPSSR,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_VPSSR,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 34
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_VPUSR_1,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_VPUSR_1,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 35
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_VPUSR_2,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_VPUSR_2,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 36
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_VPUSR_3,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_VPUSR_3,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 21
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_TEP_-_Elastic_Parameters,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_TEP_-_Elastic_Parameters,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 22
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_TEP_-_Thermal_and_Other_Parameters,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_TEP_-_Thermal_and_Other_Parameters,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 23
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_TEP_-_Plastic_Parameters_1,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_TEP_-_Plastic_Parameters_1,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 24
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_TEP_-_Plastic_Parameters_2,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_TEP_-_Plastic_Parameters_2,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 25
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_TEP_-_Parameters_Shape_Yield_Surf.,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_TEP_-_Parameters_Shape_Yield_Surf.,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 26
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_TEP_-_Parameters_Shape_Plastic_Pot.,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_TEP_-_Parameters_Shape_Plastic_Pot.,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 27
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_TEP_-_Integration_Control_Parameters,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_TEP_-_Integration_Control_Parameters,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 70
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Argillite_Bonding,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Argillite_Bonding,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 71
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Argillite_Matrix,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Argillite_Matrix,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 72
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Argillite_-_Coupling,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Argillite_-_Coupling,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 73
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Argillite_-_Yield_vol,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Argillite_-_Yield_vol,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 74
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Argillite_-_Yield_dev,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Argillite_-_Yield_dev,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 75
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Argillite_-_Plastic_vol,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Argillite_-_Plastic_vol,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 76
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Argillite_-_Plastic_dev,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Argillite_-_Plastic_dev,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 77
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Argillite_-_Hardening,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Argillite_-_Hardening,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 78
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Argillite_-_Visco,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Argillite_-_Visco,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 79
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Argillite_-_Control_Parameters,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Argillite_-_Control_Parameters,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 6
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Retention_Curve,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Retention_Curve,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 66
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Retention_Curve_2,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Retention_Curve_2,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 7
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Intrinsic_Permeability,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Intrinsic_Permeability,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 14
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Liquid_Phase_Relative_Permeability,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Liquid_Phase_Relative_Permeability,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 19
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Gas_Phase_Relative_Permeability,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Gas_Phase_Relative_Permeability,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 11
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Diffusive_Flux_of_Vapour,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Diffusive_Flux_of_Vapour,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 12
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Diffusive_Flux_of_Dissolved,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Diffusive_Flux_of_Dissolved,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 8
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Dispersive_Flux_of_Mass_and_Energy,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Dispersive_Flux_of_Mass_and_Energy,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 9
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Conductive_Flux_of_Heat_1,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Conductive_Flux_of_Heat_1,*i,REAL) 
*endfor

*endfor
*#      LAW 20
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Conductive_Flux_of_Heat_2,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Conductive_Flux_of_Heat_2,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 10
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Solid_Phase_Properties,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Solid_Phase_Properties,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 15
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Liquid_Phase_Density,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Liquid_Phase_Density,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 16
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Liquid_Phase_Viscosity,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Liquid_Phase_Viscosity,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 17
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_Gas_Phase_Density,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Gas_Phase_Density,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 18
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*set var icl=18
*for(i=1;i<(MatProp(_Gas_Phase_Viscosity,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Gas_Phase_Viscosity,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 50
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*set var icl=50
*for(i=1;i<(MatProp(_Construction_Or_Excavation,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_Construction_Or_Excavation,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 90
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_CASM_-_general,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_CASM_-_general,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 91
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_CASM_-_specific,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_CASM_-_specific,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 80
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_BExM_-_Inactive,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_BExM_-_Inactive,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 81
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_BExM_-_Elastic,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_BExM_-_Elastic,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 82
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_BExM_-_Coupling,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_BExM_-_Coupling,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 83
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_BExM_-_Yield_surface,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_BExM_-_Yield_surface,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 84
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_BExM_-_Inactive,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_BExM_-_Inactive,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 85
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_BExM_-_Plastic_potential,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_BExM_-_Plastic_potential,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 86
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_BExM_-_Macro-micro,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_BExM_-_Macro-micro,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 87
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_BExM_-_Hardening,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_BExM_-_Hardening,*i,REAL) 
*endfor

*endfor
*#
*#      LAW 88
*#
*#
*set var ilaws=operation(ilaws+1)
*set var totalprop=0
*for(i=1;i<(MatProp(_BExM_-_Convergence,INT)+1);i=i+1)
*set var totalprop=totalprop+1
*endfor
*set var matpropintvl=operation(totalprop(INT)/11)
*for(t=1;t<matpropintvl+1;t=t+1)
*ilaws(INT)
*t(INT)
*for(i=(1+11*(t-1));i<(t*11+1);i=i+1)
*MatProp(_BExM_-_Convergence,*i,REAL) 
*endfor

*endfor
   -1                    ! End material :*MatNum(INT)
*end
EndMat
